/*
#import "AppDelegate.h"
#import "ViewController.h"
#import "StartPage.h"


@implementation AppDelegate

@synthesize window = _window;
@synthesize StartPage = _StartPage;
@synthesize ViewController = _ViewController;

void uncaughtExceptionHandler(NSException *exception) {
    NSLog(@"CRASH myLog: %@", exception);
    NSLog(@"Stack myTrace: %@", [exception callStackSymbols]);
    // Internal error reporting
}


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    self.window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    // Override point for customization after application launch.
    self.StartPage = [[StartPage alloc] initWithNibName:@"StartPage" bundle:nil];
    self.window.rootViewController = self.StartPage;
    [self.window makeKeyAndVisible];
    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application
{
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}

@end

*/







#import "AppDelegate.h"
#import "ViewController.h"
#import "StartPage.h"
#define IS_IPAD (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad)
#define SCREEN_WIDTH ([[UIScreen mainScreen] bounds].size.width)
#define SCREEN_HEIGHT ([[UIScreen mainScreen] bounds].size.height)
#define IS_IPAD_PRO_1366 (IS_IPAD && MAX(SCREEN_WIDTH,SCREEN_HEIGHT) == 1366.0)
#define IS_IPAD_AIR_1112 (IS_IPAD && MAX(SCREEN_WIDTH,SCREEN_HEIGHT) == 1112.0)
#define IS_IPAD_AIR_1080 (IS_IPAD && MAX(SCREEN_WIDTH,SCREEN_HEIGHT) == 1080.0)
#define IS_IPAD_AIR_1194 (IS_IPAD && MAX(SCREEN_WIDTH,SCREEN_HEIGHT) == 1194.0)

@implementation AppDelegate

@synthesize window = _window;
@synthesize ViewController = _ViewController;

@synthesize StartPage = _StartPage;

void uncaughtExceptionHandler(NSException *exception) {
    NSLog(@"CRASH: %@", exception);
    NSLog(@"Stack Trace: %@", [exception callStackSymbols]);
    // Internal error reporting
}


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    
    NSSetUncaughtExceptionHandler(&uncaughtExceptionHandler);
    
    self.window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    // Override point for customization after application launch.
    
    self.ViewController = [[ViewController alloc] initWithNibName:@"ViewController" bundle:nil];
    // self.window.rootViewController = self.ViewController;
 
 
    self.StartPage = [[StartPage alloc] initWithNibName:@"StartPage" bundle:nil];
    
    //NSLog(@"width %f",[[UIScreen mainScreen] bounds].size.width) ;
    //NSLog(@"height %f",[[UIScreen mainScreen] bounds].size.height) ;
    
   
   if (IS_IPAD_PRO_1366) {
       //NSLog(@"iPad Pro 12.9 3rd generation");
      self.window.transform = CGAffineTransformScale(CGAffineTransformIdentity, 1.33, 1.33);
   }else if (IS_IPAD_AIR_1112) {
        //NSLog(@"3rd generation");
      self.window.transform = CGAffineTransformScale(CGAffineTransformIdentity, 1.086, 1.086);
   }else if (IS_IPAD_AIR_1080) {
        //NSLog(@"7th gen 10.2inch");
      self.window.transform = CGAffineTransformScale(CGAffineTransformIdentity, 1.05468, 1.05468);
   }else if (IS_IPAD_AIR_1194) {
        //NSLog(@"iPad Pro 11 inch");
      self.window.transform = CGAffineTransformScale(CGAffineTransformIdentity, 1.16254, 1.085);
   }else{
        //NSLog(@"7th generation or iPad Pro 9.7 inch");
       self.window.transform = CGAffineTransformScale(CGAffineTransformIdentity, 1, 1);       
   }
    
   
    // self.window.transform = CGAffineTransformScale(CGAffineTransformIdentity, 1.35, 1.4);
    self.window.rootViewController = self.StartPage;
   
    [self.window makeKeyAndVisible];
    return YES;
}


- (void)applicationWillResignActive:(UIApplication *)application
{
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application
{
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}

@end


